/* foundry-command-line-remote-private.h
 *
 * Copyright 2024 Christian Hergert <chergert@redhat.com>
 *
 * This library is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of the
 * License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License along
 * with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * SPDX-License-Identifier: LGPL-2.1-or-later
 */

#pragma once

#include <gio/gio.h>

#include "foundry-context.h"
#include "foundry-command-line-private.h"

G_BEGIN_DECLS

#define FOUNDRY_TYPE_COMMAND_LINE_REMOTE (foundry_command_line_remote_get_type())

G_DECLARE_FINAL_TYPE (FoundryCommandLineRemote, foundry_command_line_remote, FOUNDRY, COMMAND_LINE_REMOTE, FoundryCommandLine)

FoundryCommandLine *foundry_command_line_remote_new         (FoundryContext           *context,
                                                             const char               *directory,
                                                             const char * const       *env,
                                                             int                       stdin_fd,
                                                             int                       stdout_fd,
                                                             int                       stderr_fd,
                                                             GDBusConnection          *connection,
                                                             const char               *object_path);
FoundryContext     *foundry_command_line_remote_get_context (FoundryCommandLineRemote *self);

G_END_DECLS
